# how-to-read.md — SaaS OS Contract Interpretation

> Authoritative instructions for reading and applying SaaS OS contracts.
> Misuse of this document results in invalid implementations.

---

## Definition

A contract is:
- NOT a component
- NOT a mock
- NOT a suggestion

A contract IS:
- A binding agreement between Design, Engineering, and AI tooling
- A deterministic specification of UI behaviour

A contract defines:
- What the UI MAY render
- What the UI MUST render
- What the UI MUST NEVER infer

---

## Contract Structure

Each contract consists of two coupled parts:

- LEFT SIDE  → Visual reference
- RIGHT SIDE → Rules and guarantees

Both sides must be read together.

---

## Left Side — Visual Reference

Contains:
- Canonical visual states
- Reference layouts
- Approved state examples (default, loading, error, etc.)

### Left Side IS:
- Visual proof of contract viability
- Rendering reference
- Flow validation surface

### Left Side IS NOT:
- Source of truth
- Place to invent variants
- Complete list of allowed behaviour

Rule:
> If it appears visually but is not defined on the right side, it does not exist.

---

## Right Side — Contract Rules (Source of Truth)

Defines:
- State ownership
- Allowed variants
- Behavioural guarantees
- Hard prohibitions

Rule:
> In any conflict between left and right, the right side wins.

---

## Locked Elements (Non-Negotiable)

The following must NEVER change:
- Component identity
- State names
- State meanings
- Token usage
- Behavioural rules
- Accessibility guarantees

Changing any of these breaks the contract.

---

## Variable Elements (Explicit Only)

May vary ONLY if explicitly listed:
- Content (labels, text)
- Data values
- Optional slots (actions, helper text)
- Size variants (if defined)

Rule:
> If it is not listed as variable, it is not allowed.

---

## State Vocabulary (Canonical)

Allowed states:
- default
- loading
- error
- success (feedback only, never implied)
- empty

Forbidden states:
- pending
- optimistic-success
- partial-error
- saving

---

## Mutual Exclusivity Rule

At any render frame:
- EXACTLY ONE primary state is allowed

Invalid combinations:
- loading + error
- error + success
- empty + data

Purpose:
- Prevent ambiguous or misleading UI

---

## Behavioural Ownership

### UI OWNS:
- Rendering
- Visual feedback
- Focus management
- Accessibility semantics

### UI NEVER OWNS:
- Validation logic
- Timing
- Retries
- Success or failure truth
- Data mutation
- Dismissal lifecycle (unless explicitly stated)

Rule:
> If behaviour is not written in the contract, the UI must not invent it.

---

## Tokens in Contracts

Contracts may reference:
- Tokens ONLY (never raw values)

Tokens MAY control:
- Colour
- Spacing
- Typography
- Border / radius
- Elevation
- Opacity

Tokens MUST NOT encode:
- State
- Logic
- Timing
- Behaviour

---

## Canonical Components Only

Rules:
- Use canonical components only
- No detached instances
- No local overrides

If new behaviour is required:
- Do NOT fork components
- Do NOT apply ad-hoc changes
- Write a new contract

---

## Mandatory Reading Order

Contracts must be read in this order:
1. Intent
2. Rules
3. States
4. Behavioural contract
5. Visual reference

Rule:
> Never start from visuals.

---

## AI / Code Generation Rules

AI tools MUST:
- Obey state definitions
- Enforce mutual exclusivity
- Never infer missing behaviour
- Treat contracts as immutable input

Rule:
> If behaviour is undefined, AI must fail or ask.

---

## Summary (Enforced)

- Contracts are rules, not suggestions
- Right side is authoritative
- States are explicit and exclusive
- UI never owns truth or timing
- Visuals validate rules, they do not define them

Ignoring this document invalidates the system.